/*
 * rdwr.c		- Block read/write for e2fsck
 *
 * Copyright (C) 1992, 1993  Remy Card <card@masi.ibp.fr>
 *
 * This file is based on the minix file system programs fsck and mkfs
 * written and copyrighted by Linus Torvalds <Linus.Torvalds@cs.helsinki.fi>
 *
 * This file can be redistributed under the terms of the GNU General
 * Public License
 */

/*
 * History:
 * 93/05/26	- Creation from e2fsck
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <linux/fs.h>
#include <linux/ext2_fs.h>

#include "e2fsprogs.h"
#include "ckfunc.h"
#include "ckvar.h"

/*
 * read-block reads block *nr into the buffer at addr. It returns
 * 0 if the *nr is unchanged, 1 if it was changed.
 */
int read_block (int dev, unsigned long * nr, char * addr)
{
	int blk_chg = check_block_nr (nr);

	DEBUG (("DEBUG: read_block (&%d, %d)\n", *nr, (int) addr));
	last_block_read = *nr;

	if (!*nr || *nr >= BLOCKS)
	{
		memset (addr, 0, block_size);
		return changed;
	}
	if (lseek (dev, block_size * (*nr), SEEK_SET) != block_size * (*nr))
		die ("seek failed in read_block", EXIT_ERROR);
	if (read (dev, addr, block_size) != block_size)
	{
		printf ("Read error: bad block in file '");
		print_current_name ();
		printf ("'.\n");
		memset (addr, 0, block_size);
	}
	return blk_chg;
}

/*
 * write_block writes block nr to disk.
 */
void write_block (int dev, unsigned long nr, char * addr)
{
	DEBUG(("DEBUG: write_block(%d, %d)\n", nr, (int) addr));
	if (!nr)
		return;
	if (nr < FIRSTBLOCK || nr >= BLOCKS)
	{
		printf ("Internal error: trying to write bad block (%d)\n"
			"Write request ignored\n", nr);
		return;
	}
	if (lseek (dev, block_size * nr, SEEK_SET) != block_size * nr)
		die ("seek failed in write_block", EXIT_ERROR);
	if (write (dev, addr, block_size) != block_size)
	{
		printf ("Write error: bad block (%d) in file '", nr);
		print_current_name ();
		printf ("'.\n");
	}
}
