/*
 * mklost+found.c	- Creates a directory lost+found on a mounted second
 *			  extended file system
 *
 * Copyright (C) 1992, 1993  Remy Card <card@masi.ibp.fr>
 *
 * This file can be redistributed under the terms of the GNU General
 * Public License
 */

/*
 * History:
 * 93/04/22	- Creation
 */

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <sys/stat.h>

#include <linux/fs.h>
#include <linux/ext2_fs.h>

#include "e2fsprogs.h"

#define LPF "lost+found"

void main (int argc, char ** argv)
{
	char name [EXT2_NAME_LEN];
	char path [PATH_MAX];
	struct stat st;
	int i, j;
	int d;

	fprintf (stderr, "mklost+found %s, %s for EXT2 FS %s, %s\n",
		 E2FSPROGS_VERSION, E2FSPROGS_DATE,
		 EXT2FS_VERSION, EXT2FS_DATE);
	if (argc != 1)
	{
		printf ("Usage: mklost+found\n");
		exit (EXIT_USAGE);
	}
	if (mkdir (LPF, 0755) == -1)
	{
		perror ("mkdir");
		exit (EXIT_ERROR);
	}
	
	i = 0;
	memset (name, 'x', 252);
	do
	{
		sprintf (name + 252, "%02d", i);
		strcpy (path, LPF);
		strcat (path, "/");
		strcat (path, name);
		if ((d = creat (path, 0644)) == -1)
		{
			perror ("creat");
			exit (EXIT_ERROR);
		}
		i++;
		close (d);
		if (stat (LPF, &st) == -1)
		{
			perror ("stat");
			exit (EXIT_ERROR);
		}
	} while (st.st_size <= (EXT2_NDIR_BLOCKS - 1) * st.st_blksize);
	for (j = 0; j < i; j++)
	{
		sprintf (name + 252, "%02d", j);
		strcpy (path, LPF);
		strcat (path, "/");
		strcat (path, name);
		if (unlink (path) == -1)
		{
			perror ("unlink");
			exit (EXIT_ERROR);
		}
	}
	exit (EXIT_OK);
}
