/*
 * e2fsprogs.h		- Definitions used by the second extended
 *			  file system programs
 *
 * Copyright (C) 1992, 1993  Remy Card <card@masi.ibp.fr>
 *
 * This file can be redistributed under the terms of the GNU General
 * Public License
 */

/*
 * History:
 * 93/05/26	- Creation from e2fsck and mke2fs
 */

/*
 * Release date and version number
 */
#define	E2FSPROGS_DATE		"93/09/24"
#define	E2FSPROGS_VERSION	"0.3b"

/*
 * Return codes
 */
#define EXIT_OK			  0
#define EXIT_NONDESTRUCT	  1
#define EXIT_DESTRUCT		  2
#define EXIT_UNCORRECTED	  4
#define EXIT_ERROR		  8
#define EXIT_USAGE		 16
#define EXIT_LIBRARY		128

/*
 * Debugging output
 */
#ifdef NO_DEBUG
#	define DEBUG(x)		/**/
#else
#	define DEBUG(x)		if (debug) \
				{ \
					printf x; \
					fflush (stdout); \
				}
#endif

/*
 * Super block fields
 */
#define INODES			(Super->s_inodes_count)
#define BLOCKS			(Super->s_blocks_count)
#define RBLOCKS			(Super->s_r_blocks_count)
#define FREEBLOCKS		(Super->s_free_blocks_count)
#define FREEINODES		(Super->s_free_inodes_count)
#define FREEBLOCKSCOUNT		(Super->s_free_blocks_count)
#define FREEINODESCOUNT		(Super->s_free_inodes_count)
#define FIRSTBLOCK		(Super->s_first_data_block)
#define BLOCKSIZE		(Super->s_log_block_size)
#define FRAGSIZE		(Super->s_log_frag_size)
#define BLOCKSPERGROUP		(Super->s_blocks_per_group)
#define FRAGSPERGROUP		(Super->s_frags_per_group)
#define INODESPERGROUP		(Super->s_inodes_per_group)
#define	MTIME			(Super->s_mtime)
#define	WTIME			(Super->s_wtime)
#define MAGIC			(Super->s_magic)
#define VALID			(Super->s_valid)

#define NORM_FIRSTBLOCK		1

/*
 * Size of blocks buffer
 */
#define TEST_BUFFER_BLOCKS	16

/*
 * To catch all references to BLOCK_SIZE
 */
#undef BLOCK_SIZE
