/*
 * badblocks2.c		- Bad blocks management for mke2fs
 *
 * Copyright (C) 1992, 1993  Remy Card <card@masi.ibp.fr>
 *
 * This file is based on the minix file system programs fsck and mkfs
 * written and copyrighted by Linus Torvalds <Linus.Torvalds@cs.helsinki.fi>
 *
 * This file can be redistributed under the terms of the GNU General
 * Public License
 */

/*
 * History:
 * 93/05/26	- Creation from mke2fs
 */

#include <signal.h>
#include <stdio.h>
#include <unistd.h>

#include <linux/fs.h>
#include <linux/ext2_fs.h>

#include "bitops.h"
#include "e2fsprogs.h"
#include "mkfunc.h"
#include "mkvar.h"

/*
 * Perform a test of a block; return the number of
 * blocks readable/writeable.
 */
static long do_check (int dev, char * buffer, int try,
		      unsigned long current_block)
{

	long got;
	
	/* Seek to the correct loc. */
	if (lseek (dev, current_block * block_size, SEEK_SET) !=
	    current_block * block_size)
                 die("seek failed during testing of blocks", EXIT_ERROR);

	/* Try the read */
	got = read (dev, buffer, try * block_size);
	if (got < 0)
		got = 0;	
	if (got & (block_size - 1))
		printf("Weird values in do_check: probably bugs\n");
	got /= block_size;
	return got;
}

static unsigned long currently_testing = 0;

static void alarm_intr (int alnum)
{
	if (currently_testing >= BLOCKS)
		return;
	signal (SIGALRM, alarm_intr);
	alarm (5);
	if (!currently_testing)
		return;
	printf ("%d... ", currently_testing * (block_size / EXT2_MIN_BLOCK_SIZE));
	fflush (stdout);
}

void check_blocks (int dev)
{
	int try;
	long got;

	if (verbose)
	{
		printf ("Searching for bad blocks ");
		fflush (stdout);
	}
	currently_testing = 0;
	if (verbose)
	{
		signal (SIGALRM, alarm_intr);
		alarm (5);
	}
	try = TEST_BUFFER_BLOCKS;
	while (currently_testing < BLOCKS)
	{
		if (currently_testing + try > BLOCKS)
			try = BLOCKS - currently_testing;
		got = do_check (dev, blkbuf, try, currently_testing);
		currently_testing += got;
		if (got == try)
		{
			try = TEST_BUFFER_BLOCKS;
			continue;
		}
		else
			try = 1;
		if (currently_testing < FIRSTBLOCK)
			die ("bad blocks before data-area: cannot make fs",
			     EXIT_ERROR);
		mark_bad (currently_testing);
		mark_block (currently_testing);
		badblocks++;
		currently_testing++;
	}
	if (verbose)
		printf ("\n");
	if (badblocks)
		printf ("%d bad block%s\n", badblocks,
			(badblocks > 1) ? "s" : "");
}

void get_list_blocks (const char * filename)
{

	FILE * listfile;
	unsigned long blockno;

	listfile = fopen (filename, "r");
	if (listfile == (FILE *) NULL)
		die ("Can't open file of bad blocks", EXIT_ERROR);
	while (!feof (listfile))
	{
		fscanf (listfile, "%d\n", &blockno);
		mark_bad (blockno);
		mark_block (blockno);
		badblocks++;
	}
	fclose (listfile);
	if (badblocks)
		printf("%d bad block%s\n", badblocks,
			(badblocks>1) ? "s" : "");
}
